package org.msh.tb.bd.tbforms.dhis2.schedule.scheduler;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.*;
import org.jboss.seam.annotations.async.Asynchronous;
import org.jboss.seam.annotations.async.Expiration;
import org.jboss.seam.annotations.async.IntervalCron;
import org.jboss.seam.async.QuartzTriggerHandle;
import org.msh.tb.bd.tbforms.dhis2.schedule.asynctask.DHIS2ExportTB10ScheduleAsyncTask;

import java.util.Date;

/**
 * Created by mauri on 07/07/2017.
 */
@AutoCreate
@Name("dHIS2TB10ExportationScheduler")
@Scope(ScopeType.APPLICATION)
public class DHIS2TB10ExportationScheduler extends DHIS2ExportationScheduler {

    @Override
    @Asynchronous
    @Transactional
    public QuartzTriggerHandle createQuartzTimer(
            @Expiration Date when, @IntervalCron String interval) {

        // start TB 10 exportation
        taskManager.runTask(DHIS2ExportTB10ScheduleAsyncTask.class, getParams());

        return null;
    }
}
